
<h1 align="center"> Heterogeneous-Agent Soft Actor-Critic </h1>

This repository develops Heterogeneous-Agent Soft Actor-Critic (HASAC)
on seven benchmarks.

## Installation

### Install HASAC

```shell
conda create -n hasac python=3.8
conda activate hasac
# install pytorch>=1.8.0 (CUDA>=11.0) manually
pip install -e .
```



### Install environments dependencies

We provide seven environments for direct usage. You may choose to install the dependencies to the environments you want to use.



**Install Google Research Football**

Please follow [the official instructions](https://github.com/google-research/football) to install Google Research Football.



**Install SMAC**

Please follow [the official instructions](https://github.com/oxwhirl/smac) to install SMAC.



**Install Light Aircraft Game**

Please follow [the official instructions](https://github.com/liuqh16/CloseAirCombat) to install Light Aircraft Game.


**Install MPE**

```shell
pip install pettingzoo==1.22.2
pip install supersuit==3.7.0
```


**Install Dependencies of Bi-DexterousHands**

Bi-DexterousHands depend on IsaacGym. The hardware requirements of IsaacGym has to be satisfied. To install IsaacGym, download IsaacGym Preview 4 release from [its official website](https://developer.nvidia.com/isaac-gym/download). Then run `pip install -e .` under its `python` folder.


**Install Gym Suite (except MuJoCo)**

```shell
# gym
pip install gym
# classic control
pip install gym[classic_control]
# box2d
conda install -c anaconda swig
pip install gym[box2d]
# atari
pip install --upgrade pip setuptools wheel
pip install opencv-python
pip install atari-py
pip install gym[atari]
pip install autorom[accept-rom-license]
```



**Install MuJoCo**

First, follow the instructions on https://github.com/openai/mujoco-py, https://www.roboti.us/, and https://github.com/deepmind/mujoco to download the right version of mujoco you need.

Second, `mkdir ~/.mujoco`.

Third, move the .tar.gz or .zip to `~/.mujoco`, and extract it using `tar -zxvf` or `unzip`.

Fourth, add the following line to the `.bashrc`:

```shell
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/home/<user>/.mujoco/<folder-name, e.g. mujoco210, mujoco-2.2.1>/bin
```

Fifth, run the following command:

```shell
sudo apt install libosmesa6-dev libgl1-mesa-glx libglfw3
pip install mujoco
pip install gym[mujoco]
sudo apt-get update -y
sudo apt-get install -y patchelf
```



**Install dependencies of MAMuJoCo**

First follow the instructions above to install MuJoCo. Then run the following commands.

```shell
pip install "mujoco-py>=2.1.2.14"
pip install "Jinja2>=3.0.3"
pip install "glfw>=2.5.1"
pip install "Cython>=0.29.28"
```



### Solve dependencies

After the installation above, run the following commands to solve dependencies.

```shell
pip install gym==0.21.0
pip install pyglet==1.5.0
pip install importlib-metadata==4.13.0
```



## Usage

### Training on existing environments

To train hasac on a provided environment, users only need to modify yaml configuration files of the corresponding algorithm and environment under `hasac/cfg/algo` and `hasac/cfg/env` as they wish, and then start training with a one-liner `python train.py --algo <ALGO> --env <ENV> --exp_name <EXPERIMENT NAME>`, or `python train.py --load_config <CONFIG FILE PATH>`, where the latter is mostly used when reproducing an experiment.

During training, users receive continuous logging feedback in the terminal. 

After training, users can check the log file and tensorboard figures. Moreover, users can also see the trained agents perform by setting `use_render: True`, `model_dir: <path to trained models>` in algorithm configuration file, and use the same training command as above again.

To enable batch running, we allow users to modify yaml configs in the command line. For each training command, users specify the special parameters in the commands with the same names as in the config files. For example, if you want to run HASAC on MAMuJoCo under three random seeds. You can customize the configs and replace `train.sh` with the following commands:

```shell
for seed in $(seq 1 3)
do
	python train.py --algo hasac --env mamujoco --exp_name installtest --seed $seed
done
```