from abc import abstractmethod
from integrator.base import Solver


class PDE:
    
    def __init__(self, grid, ic, t0):
        self.grid = grid
        self.t0 = t0
        self.ic = ic
        if grid is not None:
            self.n = len(self.grid)
            self.dx = float((grid[-1] - grid[0]) / (self.n - 1))
        else:
            self.n = 0
            self.dx = None

    
    @abstractmethod
    def attach_solver(self, solver: Solver):
        # establish the differentiation methods and the rhs function for the solver
        pass