from pde.base import PDE
from integrator.base import Solver


class Burgers(PDE):
    # Ut = -U Ux + nu Uxx 
    
    # only support 1D uniform grid
    def __init__(self, grid, ic = None, t0 = 0, nu = 0):
        super().__init__(grid, ic, t0)
        self.visc = (nu != 0)
        self.nu = nu
    
    
    def attach_solver(self, solver: Solver):
        def rhs(x, t):
            term1 = -x * solver.Dx(x) 
            term2 = self.nu * solver.Dxx(x)
            return term1 + term2
        solver.rhs = rhs

            
        
        