
import numpy as np
import numpy.random as rand
from scipy.stats import norm as normal, multivariate_normal as mult_normal
from scipy.interpolate import CubicHermiteSpline as Hermite
import torch
from numpy import sin, cos, pi, log, sqrt, exp



def sample_trig_ic(L, R, xs, seed = None):
    if seed is not None:
        rand.seed(seed)
    coef = mult_normal(mean = np.ones(3)/2, cov = np.eye(3) / 10**2).rvs()
    fact = (2 * pi) / (R - L)
    ic = (coef[0] * sin(fact * xs) + coef[1] * cos(fact * xs) + coef[2])
    return torch.tensor(ic)
    