from omegaconf import DictConfig

from .maxvit_rnn import RNNDetector as MaxViTRNNDetector
from .SATEbackbone import build_SATE_backbone


def build_recurrent_backbone(backbone_cfg: DictConfig, dataset_name='gen1'):
    name = backbone_cfg.name
    assert dataset_name == 'gen1' or dataset_name == 'gen4' or dataset_name == 'etram'
    if name == 'MaxViTRNN':
        return MaxViTRNNDetector(backbone_cfg)
    elif name == "SATE":
        return build_SATE_backbone(dataset_name=dataset_name)
    else:
        raise NotImplementedError
