import numpy as np
from tensorly.tenalg import multi_mode_dot as mmd
from sklearn.preprocessing import normalize


def lgm(parameter):            # latent graph embedding model or tensor-based latent space model
    n = parameter[0]           # number of vertices
    M = parameter[1]           # number of layers
    K = parameter[2]           # number of communities
    R = parameter[3]           # embedding dimension
    sigma = parameter[4]       # standard deviation of alpha
    s_n = parameter[5]         # sparsity factor
    scalar = parameter[6]      # controls the magnitude of embedding center
    seed = parameter[7]        # seed for repetition
    np.random.seed(seed)
    Identity = np.zeros([R] * 3)
    for r in range(R):
        Identity[tuple([r] * 3)] = 1
    Z = np.random.multinomial(1, [1/K]*K, n)
    psi_star = np.where(Z)[1]
    while True:
        flag = 0
        C = np.random.binomial(1, 0.5, (K, R))
        for k_1 in range(K):
            for k_2 in range(k_1+1, K):
                if not((C[k_1] - C[k_2]).any()):
                    flag += 1
        if flag == 0:
            break
    C = (2.0 * C - 1) * scalar
    alpha_star = Z @ C + np.random.normal(0, sigma, (n, R))
    beta_star = np.random.normal(0, 1, (M, R))
    beta_star = normalize(beta_star.T).T*np.sqrt(M)
    Theta_star = mmd(Identity, [alpha_star, alpha_star, beta_star])
    P_star = s_n / (1 + np.exp(-Theta_star))
    A = np.random.binomial(1, P_star)
    for m in range(M):
        A[:, :, m] = np.triu(A[:, :, m]) + np.triu(A[:, :, m], 1).T
    print("data generation")
    return A, psi_star


def lgm_theta(parameter):
    n = parameter[0]           # number of vertices
    M = parameter[1]           # number of layers
    K = parameter[2]           # number of communities
    R = parameter[3]           # embedding dimension
    sigma = parameter[4]       # standard deviation of alpha
    s_n = parameter[5]         # sparsity factor
    scalar = parameter[6]      # controls the magnitude of embedding center
    seed = parameter[7]        # seed for repetition
    np.random.seed(seed)
    Identity = np.zeros([R] * 3)
    for r in range(R):
        Identity[tuple([r] * 3)] = 1
    Z = np.random.multinomial(1, [1/K]*K, n)
    psi_star = np.where(Z)[1]
    while True:
        flag = 0
        C = np.random.binomial(1, 0.5, (K, R))
        for k_1 in range(K):
            for k_2 in range(k_1+1, K):
                if not((C[k_1] - C[k_2]).any()):
                    flag += 1
        if flag == 0:
            break
    C = (2.0 * C - 1) * scalar
    alpha_star = Z @ C + np.random.normal(0, sigma, (n, R))
    beta_star = np.random.normal(0, 1, (M, R))
    beta_star = normalize(beta_star.T).T*np.sqrt(M)
    Theta_star = mmd(Identity, [alpha_star, alpha_star, beta_star])
    P_star = s_n / (1 + np.exp(-Theta_star))
    A = np.random.binomial(1, P_star)
    for m in range(M):
        A[:, :, m] = np.triu(A[:, :, m]) + np.triu(A[:, :, m], 1).T
    print("data generation")
    return A, Theta_star


def lgm_K(parameter):
    n = parameter[0]           # number of vertices
    M = parameter[1]           # number of layers
    K = parameter[2]           # number of communities
    R = parameter[3]           # embedding dimension
    sigma = parameter[4]       # standard deviation of alpha
    s_n = parameter[5]         # sparsity factor
    scalar = parameter[6]      # controls the magnitude of embedding center
    seed = parameter[7]        # seed for repetition
    p = parameter[8]
    np.random.seed(seed)
    Identity = np.zeros([R] * 3)
    for r in range(R):
        Identity[tuple([r] * 3)] = 1
    Z = np.random.multinomial(1, p, n)
    psi_star = np.where(Z)[1]
    while True:
        flag = 0
        C = np.random.binomial(1, 0.5, (K, R))
        for k_1 in range(K):
            for k_2 in range(k_1+1, K):
                if not((C[k_1] - C[k_2]).any()):
                    flag += 1
        if flag == 0:
            break
    C = (2.0 * C - 1) * scalar
    alpha_star = Z @ C + np.random.normal(0, sigma, (n, R))
    beta_star = np.random.normal(0, 1, (M, R))
    beta_star = normalize(beta_star.T).T*np.sqrt(M)
    Theta_star = mmd(Identity, [alpha_star, alpha_star, beta_star])
    P_star = s_n / (1 + np.exp(-Theta_star))
    A = np.random.binomial(1, P_star)
    for m in range(M):
        A[:, :, m] = np.triu(A[:, :, m]) + np.triu(A[:, :, m], 1).T
    print("data generation")
    return A, psi_star
