import itertools as it
import numpy as np
from scipy.optimize import linear_sum_assignment


def hamming_error(assignment):
    a = np.array(assignment[0])
    b = np.array(assignment[1])
    n = len(a)
    K = len(set(a))
    permu_a = [0] * n
    err_under_permu = []
    for item in it.permutations(range(K)):
        for i in range(n):
            permu_a[i] = item[a[i]]
        err_under_permu.append(sum(np.array(permu_a) != np.array(b)))
    return min(err_under_permu) / n


def hungarian_hamming_error(assignment):
    a = np.array(assignment[0])
    b = np.array(assignment[1])
    n = len(a)
    K = len(set(a))
    cost_matrix = np.zeros((K, K))
    for k1 in range(K):
        for k2 in range(K):
            set_k1 = set(np.where(a == k1)[0])
            set_k2 = set(np.where(b == k2)[0])
            set_intersection = set_k1.intersection(set_k2)
            cost_matrix[k1, k2] = -len(set_intersection)
    permutation = linear_sum_assignment(cost_matrix)
    permu_b = np.zeros(n)
    label_order = permutation[1]
    for k2 in range(K):
        index = np.where(b == label_order[k2])[0]
        permu_b[index] = k2
    return sum(np.array(a) != np.array(permu_b))/n


