import numpy as np
from tensorly.decomposition import tucker


def transformed_tucker(A, R, max_iter=20):
    n, M = A.shape[0], A.shape[2]
    P = (2.0*A-1) * 100
    if M < R:
        core, factors = tucker(P, rank=[R, R, M], init='svd', n_iter_max=max_iter)
    else:
        core, factors = tucker(P, rank=[R, R, R], init='svd', n_iter_max=max_iter)
    beta = factors[2]
    if M < R:
        beta = np.hstack((beta, np.ones((M, R - M))))
    return factors[1]*np.sqrt(n), beta*np.sqrt(M)


def regular_tucker(A, R, max_iter=20):
    n, M = A.shape[0], A.shape[2]
    core, factors = tucker(A, rank=[R, R, R], init='svd', n_iter_max=max_iter)
    beta = factors[2]
    if M < R:
        beta = np.hstack((beta, np.zeros((M, R - M))))
    return factors[1]*np.sqrt(n), beta*np.sqrt(M)

