from tensorly.decomposition import tucker
from sklearn.cluster import KMeans
import numpy as np
from tensorly.tenalg import multi_mode_dot as mmd


def hosvd_tucker(parameter):
    A = parameter[0]
    K = parameter[1]
    A = A + 0.0
    core, factor = tucker(A, rank=[K, K, K], init='svd', n_iter_max=50)
    kmeans = KMeans(n_clusters=K).fit(factor[0])
    return kmeans.labels_


def hosvd_tucker_link_prediction(parameter):
    A = parameter[0]
    K = parameter[1]
    frac = parameter[2]
    tensor_type = A.shape
    n, M = tensor_type[0], tensor_type[2]
    B = np.random.binomial(1, frac, (n, n, M))
    for m in range(M):
        B[:, :, m] = np.triu(B[:, :, m]) + np.triu(B[:, :, m], 1).T
    B0 = np.zeros(B.shape)
    for m in range(M):
        B0[:, :, m] = np.triu(B[:, :, m])  # indicator of independent random variables in A.
    A = A + 0.0
    core, factor = tucker(A * B, rank=[K, K, K], init='svd', n_iter_max=30)
    P_hat = mmd(core, factor)
    P_hat[P_hat < 0] = 0
    P_hat[P_hat > 1] = 1
    A_hat = np.random.binomial(1, P_hat)
    B0_tilde = 1 - B0
    for m in range(M):
        B0_tilde[:, :, m] = np.triu(B0_tilde[:, :, m])
    return (np.abs((A_hat - A) * B0_tilde)).sum() / B0_tilde.sum()
