#!/bin/bash

# Number of concurrent processes
MAX_JOBS=1

# Array of experiments to run (add your experiments here)
experiments=(
  "python ../evaluate/evaluate_ours_multitask.py +config=ours_multi config.wandb.experiment_name=ours_multi_position config.huggingface.branch=ours_multi_position"
  "python ../evaluate/evaluate_esn_multitask.py +config=esn_multi config.wandb.experiment_name=esn_multi config.huggingface.branch=esn_multi"
  "python ../evaluate/evaluate_feedforward_multitask.py +config=feedforward_multi config.wandb.experiment_name=feedforward_multi config.huggingface.branch=feedforward_multi"
#   "python ../evaluation.py +config=ours_multi config/architecture=ours_multi_pos_delta config.wandb.experiment_name=ours_multitask_position_delta config.huggingface.branch=ours_multitask_position_delta"
#   "python ../evaluation.py +config=ours_multi config/architecture=ours_multi_vel config.wandb.experiment_name=ours_multitask_velocity config.huggingface.branch=ours_multitask_velocity"
)

# Function to run a command and manage the number of concurrent jobs
run_experiment() {
    local cmd="$1"
    echo "Running: $cmd"
    eval "$cmd"
}

# Loop over the experiments and run them
for experiment in "${experiments[@]}"; do
    # Wait for any job to finish if we reached the maximum concurrent jobs
    while [[ $(jobs -r -p | wc -l) -ge $MAX_JOBS ]]; do
        wait -n
    done

    # Start the experiment in the background
    run_experiment "$experiment" &
done

# Wait for any remaining jobs
wait

echo "All experiments completed."
