#!/bin/bash

# Number of concurrent processes
MAX_JOBS=1

# Array of experiments to run (add your experiments here)
experiments=(
#   "python ../evaluate/evaluate_feedforward.py +config=feedforward config.dataset.shape=Sshape config.wandb.experiment_name=feedforward_no_chunk_Sshape config.architecture.model_params.output_dim=2 config.architecture.inference_params.action_chunks=1 config.architecture.inference_params.num_predicted_actions=2 config.dataset.window_size=2 config.architecture.inference_params.prediction_horizon=1"
#   "python ../evaluate/evaluate_feedforward.py +config=feedforward config.dataset.shape=CShape config.wandb.experiment_name=feedforward_no_chunk_CShape config.architecture.model_params.output_dim=2 config.architecture.inference_params.action_chunks=1 config.architecture.inference_params.num_predicted_actions=2 config.dataset.window_size=2 config.architecture.inference_params.prediction_horizon=1"
#   "python ../evaluate/evaluate_feedforward.py +config=feedforward config.dataset.shape=LShape config.wandb.experiment_name=feedforward_no_chunk_LShape config.architecture.model_params.output_dim=2 config.architecture.inference_params.action_chunks=1 config.architecture.inference_params.num_predicted_actions=2 config.dataset.window_size=2 config.architecture.inference_params.prediction_horizon=1"


  "python ../evaluate/evaluate_feedforward.py +config=feedforward config.dataset.shape=Sshape config.wandb.experiment_name=feedforward_Sshape config.huggingface.branch=feedforward_Sshape"
  "python ../evaluate/evaluate_feedforward.py +config=feedforward config.dataset.shape=CShape config.wandb.experiment_name=feedforward_CShape config.huggingface.branch=feedforward_CShape"
  "python ../evaluate/evaluate_feedforward.py +config=feedforward config.dataset.shape=LShape config.wandb.experiment_name=feedforward_LShape config.huggingface.branch=feedforward_LShape"

  "python ../evaluate/evaluate_esn.py +config=esn config.dataset.shape=Sshape config.wandb.experiment_name=esn_Sshape config.huggingface.branch=esn_Sshape"
  "python ../evaluate/evaluate_esn.py +config=esn config.dataset.shape=CShape config.wandb.experiment_name=esn_CShape config.huggingface.branch=esn_CShape"
  "python ../evaluate/evaluate_esn.py +config=esn config.dataset.shape=LShape config.wandb.experiment_name=esn_LShape config.huggingface.branch=esn_LShape"

  "python ../evaluate/evaluate_ours.py +config=ours config.dataset.shape=Sshape config.wandb.experiment_name=ours_Sshape config.huggingface.branch=ours_Sshape"
  "python ../evaluate/evaluate_ours.py +config=ours config.dataset.shape=CShape config.wandb.experiment_name=ours_CShape config.huggingface.branch=ours_CShape"
  "python ../evaluate/evaluate_ours.py +config=ours config.dataset.shape=LShape config.wandb.experiment_name=ours_LShape config.huggingface.branch=ours_LShape"
)

# Function to run a command and manage the number of concurrent jobs
run_experiment() {
    local cmd="$1"
    echo "Running: $cmd"
    eval "$cmd"
}

# Loop over the experiments and run them
for experiment in "${experiments[@]}"; do
    # Wait for any job to finish if we reached the maximum concurrent jobs
    while [[ $(jobs -r -p | wc -l) -ge $MAX_JOBS ]]; do
        wait -n
    done

    # Start the experiment in the background
    run_experiment "$experiment" &
done

# Wait for any remaining jobs
wait

echo "All experiments completed."
