import os
import pickle
from shutil import copyfile

class ResultSaver(object):
    def __init__(self,result_file=None):
        '''
        if result_file is None, results are not stored in a pickle file
        '''
        self.result_file = result_file
        self.results = {} # only used if result_file is None
        
    def load_results(self):
        if self.result_file is None:
            return self.results
        else:
            if not os.path.isfile(self.result_file):
                return {}
            else:
                with open(self.result_file,'rb') as f:
                    return pickle.load(f)

    def dump_results(self,results):
        if self.result_file is None:
            self.results = results
        else:
            with open(self.result_file,'wb') as f:
                pickle.dump(dict(results),f)

    def update_results(self,path, new_data):
        results = self.load_results()
        position = results
        for p in path:
            position = position[p]
        # new_data is a dictionary with the new (key,value) pairs
        position.update(new_data)
        self.dump_results(results)
        
    def backup_results(self):
        results = self.load_results()
        if bool(results): # if results is not empty
            copyfile(self.result_file,self.result_file[:-2]+'-backup.p')
     
    def restore_backup(self):
        copyfile(self.result_file[:-2]+'-backup.p',self.result_file)