### Diffusion Denoising of Datasets

Note that diffusion models can be downloaded from [here](https://github.com/openai/improved-diffusion). Put them under the `models/cifar10/denoiser`

#### How to Run

This code is to denoise the clean datasets. To run it with CIFAR10 and denoise the data with a specific sigma, you can:

```
    $ python denoise.py \
        --dataset cifar10 \
        --network DiffusionDenoiser \
        --batch-size 32 \
        --sigma 1.0
```


To run the script over multiple sigma values and trials, you can use the `denoise.sh`. You may first configure the script with modifying the contents:

```
    SIGMA=(0.1 0.2 0.3 0.5 1.0 2.0 3.0)     # sigma values
    BATCH=256                               # batch size
    TRIAL=10                                # num-trials, e.g., run 10 times with the same sigma
```


All the denoised data is stored under `datasets/denoised` folder, following the format `datasets/denoised/<dataset>/filename`; for example, `datasets/denoised/cifar10/denoised_w_sigma_1.0.pt`. Note that we stored the data using `torch.save` and it contains the dictionary below:

```
    Note  : we denoise the data in [0, 1]
    Format: {
        'train_data'  : pytorch tensor of (50k, 3, 32, 32),     <- FloatTensor
        'train_labels': pytorch tensor of (50k),                <- LongTensor
        'test_data'   : pytorch tensor of (10k, 3, 32, 32),
        'test_labels' : pytorch tensor of (10k)m
    }
```


#### How to Load the Denoised Data.

We provide the code for loading the denoised data in `load.py`.

**Thx.**
