#!/bin/bash

# construct the denoised datasets
SIGMA=(0.1 0.2 0.3 0.5 1.0 2.0 3.0)
BATCH=256
TRIAL=10

# run over the sigma values
for each_sigma in "${SIGMA[@]}"; do
for each_trial in $(seq 1 $TRIAL); do

    echo "python denoise.py \
            --dataset cifar10 \
            --network DiffusionDenoiser \
            --batch-size $BATCH \
            --sigma $each_sigma \
            --trial $each_trial"

    python denoise.py \
        --dataset cifar10 \
        --network DiffusionDenoiser \
        --batch-size $BATCH \
        --sigma $each_sigma \
        --trial $each_trial

done
done