# How to Reproduce the Results of the Numerical Experiments in Section 3.

## Preparation

### Python Environment
You may need to create a virtual environment and install the following packages using pip:

```
python -m venv ./env_dre_expr
source ./env_dre_expr/bin/activate
pip install --upgrade pip
pip install numpy
pip install pandas
pip install matplotlib
pip install -U scikit-learn
pip install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cu118
pip install lightning
pip install tensorboard
pip install wandb
```

#### 2. Initialize WandB and Log In
Our code uses the ```wandb``` library. 
You will need to log in to your WandB account to run these scripts. 

After installing the library, run the following command to log in:

```
wandb login
```


---

## Running the Experiments


### Reproducing the Results of experiments investigating the relationship between $L_p$ errors and KL-divergence in the data.

#### 1. Generate Datasets
First, generate the datasets used in the experiments. The datasets will be saved in the ```data/``` directory:

```
source env_dre_expr/bin/activate
python 2-1_generate_data_Section_3_Lp-KLdivergence.py
```

#### 2. Run Scripts
To reproduce all the results of the experiments, run the following script:

* **For the $\alpha$-divergence loss function**:  
  To reproduce all the results of the $\alpha$-divergence loss function, run the following script:

  ```
  source env_dre_expr/bin/activate
  python 2-1_run_experiment_Section_3_Lp-KLdivergence_alphaLoss.py
  ```

* **For the KL-divergence loss function**:  
  To reproduce all the results of the KL-divergence loss function, run the following script:

  ```
  source env_dre_expr/bin/activate
  python 2-1_run_experiment_Section_3_Lp-KLdivergence_KLloss.py
  ```


### Reproducing the Results of experiments investigating the relationship between $L_p$ errors and the dimensionality of the data.

#### 1. Generate Datasets
First, generate the datasets used in the experiments. The datasets will be saved in the ```data/``` directory:

```
source env_dre_expr/bin/activate
python 2-2_generate_data_Section_3_Lp-dimenstion.py
```

#### 2. Run Scripts
To reproduce all the results of the experiments, run the following script:

* **For the $\alpha$-divergence loss function**:  
  To reproduce all the results of the $\alpha$-divergence loss function, run the following script:

  ```
  source env_dre_expr/bin/activate
  python 2-2_run_experiment_Section_3_Lp-dimension-alphaLoss.py
  ```

* **For the KL-divergence loss function**:  
  To reproduce all the results of the KL-divergence loss function, run the following script:

  ```
  source env_dre_expr/bin/activate
  python 2-2_run_experiment_Section_3_Lp-dimension-KLloss.py
  ```