import os
import numpy as np
from PIL import Image

# Create output directory
output_directory = "./random_data_easy_nonmatch/white_noise_images"
os.makedirs(output_directory, exist_ok=True)

# Function to generate a white noise image
def generate_white_noise_image(width=256, height=256):
    # Generate random pixel values
    noise = np.random.randint(0, 256, (height, width, 3), dtype=np.uint8)
    return Image.fromarray(noise)

# Generate 5000 white noise images
for i in range(5000):
    filename = f"WN_{i:06d}.png"
    filepath = os.path.join(output_directory, filename)
    image = generate_white_noise_image()
    image.save(filepath)