# Constrained Transformer Unrolling: Language

This repository contains the implementation for constrained unrolled transformers with descent constraints for language tasks.

## Setup

Create a conda environment and install dependencies:

```bash
conda create -n constrained_trf_unrolling_lang python==3.10
conda activate constrained_trf_unrolling_lang
pip install -e .[dev]
```

## Quick Start

### Basic Usage

Run a constrained experiment on IMDB:
```bash
python src/constrained_trf_unrolling_language/train_lightning.py \
    --dataset imdb \
    --constraint_type cross_entropy \
    --constraint_alpha 0.9 \
    --model unrolled_transformer \
    --num_epochs 5 \
    --batch_size 32 \
    --devices 1 \
    --accelerator gpu
```

Run an unconstrained baseline:
```bash
python src/constrained_trf_unrolling_language/train_lightning.py \
    --dataset imdb \
    --constraint_type none \
    --model unrolled_transformer \
    --num_epochs 5 \
    --batch_size 32 \
    --devices 1 \
    --accelerator gpu
```

### Supported Datasets
- `imdb`: Binary sentiment classification
- `mnli`: Natural language inference (3-class)
