# Constrained Transformer Unrolling

This repository contains the implementation for constrained unrolled transformers with descent constraints for video frame reconstruction tasks.

## Setup

Create a conda environment and install dependencies:

```bash
conda create -n constrained_trf_unrolling python==3.10
conda activate constrained_trf_unrolling
pip install -e .
```

## Quick Start

### Basic Usage
Here is an example of running the code for DUST with the UCSD dataset.
```bash
python frame_reconstruction.py \
    -m dust_vec \
    -ld0 0.3 \
    -ld1 0.9 \
    -ld2 0.25701 \
    -learn_ld0 0 \
    -learn_ld1 0 \
    -learn_ld2 0 \
    --h0_init ones \
    -cf 4 \
    -d ucsd \
    -cpt checkpoints \
    -epoch 10 \
    -lr 1e-4 \
    -gc \
    --wandb_project video_denoising \
    --experiment_tag wandb_experiment_tag \
    --batch_size 8 \
    --noise-schedule linear \
    --num_layers 3 \
    --constraint_type 'none' \
    --perturb 0.0 \
    --initial_energy 1.0
```

### Supported Datasets
- `ucsd`: UCSD Anomaly Detection dataset
- `shanghaitech`: ShanghaiTech dataset
- `avenue`: Avenue dataset

### Supported Models
- `unrolled_transformer`: Transformer-based unrolled optimization
- `dust_vec`: DUST (Deep Unfolding with Sparse Transformations)
- `vit`: Vision Transformer for reconstruction

### Key Parameters
- `--constraint_type`: `energy`, `loss`, `mse` (constrained) or `none` (unconstrained)
- `--constraint_alpha`: Constraint strength parameter (default: 1.0)
- `--num_layers`: Number of unrolling layers (default: 3)
- `--perturb`: Training noise level (default: 0.0)
- `--lr_dual`: Learning rate for dual variables (default: 1e-5)
