# Collaborative Prompt Tuning for Black-Box Vision-Language Models
Official implementation of Collaborative Prompt Tuning for Black-Box Vision-Language Models. 

## Requirements
### Installation
Create a conda environment and install dependencies:
```
conda create -n carrot python=3.9
conda activate carrot

pip install -r requirements.txt

# Install the according versions of torch and torchvision
conda install pytorch torchvision cudatoolkit
```

### Dataset
Follow DATASET.md to install ImageNet and other 10 datasets referring to CoOp.

## Get Started
### Configs
The running configurations can be modified in `carrot_configs/dataset.yaml`, including shot numbers, visual encoders, and hyperparamters. 

### Numerical Results
We provide  **numerical results** in few-shot classification and robustness to distribution shift at exp.log.

### Running
For ImageNet dataset:
```bash
CUDA_VISIBLE_DEVICES=0 python main_carrot_imagenet.py --config carrot_configs/imagenet.yaml
```
For other 10 datasets:
```bash
CUDA_VISIBLE_DEVICES=0 python main_carrot.py --config carrot_configs/dataset.yaml