import os
from openpyxl import Workbook
import numpy as np 
from nltk.translate.bleu_score import sentence_bleu
from nltk.translate.bleu_score import SmoothingFunction
from IPython import embed
from io import StringIO
from sklearn import linear_model
import numpy as np
from matplotlib.ticker import MaxNLocator
from collections import namedtuple
from IPython import embed
import math
    
wb = Workbook()
ws = wb.active
ws.append(('dataset', 'loader_type', 'model', 'optimizer', 'defense', 'AR', 'attacks', 'attacker', 'ACC', 'ACC_std', 'ASR', 'ASR_std', 'n'))
epoch = 10
score_dict = {}

for line in open('log.csv'):
    if line.startswith('dataset'):
        continue
    if '#delete#' in line:
        continue
    dataset, loader_type, model, optimizer, defense, AR, attacks, attacker, steps, ACC, ASR = line.strip().split(',')
    if epoch != int(steps):
        continue
    ACC, ASR = float(ACC), float(ASR)
    name = '_'.join([dataset, loader_type, model, optimizer, defense, AR, attacks])
    if not (name in score_dict):
        score_dict[name] = {}
    if attacker in score_dict[name]:
        if (ACC, ASR) != score_dict[name][attacker]:
            print(name, attacker, flush=True)
    score_dict[name][attacker] = (ACC, ASR)

for name in score_dict:
    if 'clean' in name:
        output = name.split('_')
        output += ['clean', score_dict[name]['clean'][0], 0, score_dict[name]['clean'][1], 0, 1]
        ws.append(output) 
    else:
        ASR1, ASR2, ASR3, ASR4, ACC1, ACC2, ACC3, ACC4 = [], [], [], [], [], [], [], []
        for attacker in score_dict[name]:
            if 'clean' in attacker:
                output = name.split('_')
                output += ['clean', score_dict[name]['clean'][0], 0, score_dict[name]['clean'][1], 0, 1]
                ws.append(output)
                continue
            n = len(attacker.split('-'))
            if n == 1:
                ASR1.append(score_dict[name][attacker][1])
                ACC1.append(score_dict[name][attacker][0])
            elif n == 2:
                ASR2.append(score_dict[name][attacker][1])
                ACC2.append(score_dict[name][attacker][0])
            elif n == 3:
                ASR3.append(score_dict[name][attacker][1])
                ACC3.append(score_dict[name][attacker][0])
            elif n == 4:
                ASR4.append(score_dict[name][attacker][1])
                ACC4.append(score_dict[name][attacker][0])
            else:
                assert(False)
        if len(ASR1) > 0:
            output = name.split('_')
            output += ['single', np.mean(ACC1), np.std(ACC1, ddof=1), np.mean(ASR1), np.std(ASR1, ddof=1), len(ASR1)]
            ws.append(output)
        if len(ASR2) > 0:
            output = name.split('_')
            output += ['2-atk', np.mean(ACC2), np.std(ACC2, ddof=1), np.mean(ASR2), np.std(ASR2, ddof=1), len(ASR2)]
            ws.append(output)
        if len(ASR3) > 0:
            output = name.split('_')
            output += ['3-atk', np.mean(ACC3), np.std(ACC3, ddof=1), np.mean(ASR3), np.std(ASR3, ddof=1), len(ASR3)]
            ws.append(output)
        if len(ASR4) > 0:
            output = name.split('_')
            output += ['4-atk', np.mean(ACC4), np.std(ACC4, ddof=1), np.mean(ASR4), np.std(ASR4, ddof=1), len(ASR4)]
            ws.append(output)
        
wb.save("result_%d.xlsx" % (epoch))