model = dict(type='VA_SF')
dataset_type = 'KSoundDataset'
data_root = 'data/ksound/'
train_pipeline = [
    dict(
        type='LoadKSoundFromZip',
        video_zip_name='data/ksound/train-frame.zip',
        audio_zip_name='data/ksound/train-audio-npy.zip'),
    dict(type='Collect', keys=['img', 'audio'], meta_keys=[])
]
test_pipeline = [
    dict(
        type='LoadKSoundFromZip',
        video_zip_name='data/ksound/train-frame.zip',
        audio_zip_name='data/ksound/train-audio-npy.zip'),
    dict(type='Collect', keys=['img', 'audio'], meta_keys=['filename'])
]
data = dict(
    imgs_per_gpu=32,
    workers_per_gpu=4,
    train=dict(
        type='KSoundDataset',
        ann_file='data/ksound/train-frame.zip',
        img_prefix='',
        pipeline=[
            dict(
                type='LoadKSoundFromZip',
                video_zip_name='data/ksound/train-frame.zip',
                audio_zip_name='data/ksound/train-audio-npy.zip'),
            dict(type='Collect', keys=['img', 'audio'], meta_keys=[])
        ]),
    test=dict(
        type='KSoundDataset',
        ann_file='data/ksound/train-frame.zip',
        img_prefix='',
        pipeline=[
            dict(
                type='LoadKSoundFromZip',
                video_zip_name='data/ksound/train-frame.zip',
                audio_zip_name='data/ksound/train-audio-npy.zip'),
            dict(
                type='Collect', keys=['img', 'audio'], meta_keys=['filename'])
        ]))
train_cfg = dict()
test_cfg = dict()
evaluation = dict(interval=1, metric='bbox')
optimizer = dict(type='Adam', lr=0.0003, weight_decay=0.0001)
optimizer_config = dict(grad_clip=dict(max_norm=35, norm_type=2))
lr_config = dict(
    policy='step',
    warmup='linear',
    warmup_iters=500,
    warmup_ratio=0.3333333333333333,
    step=[60, 80])
checkpoint_config = dict(interval=1, create_symlink=False)
log_config = dict(interval=10, hooks=[dict(type='TextLoggerHook')])
total_epochs = 90
dist_params = dict(backend='nccl')
log_level = 'INFO'
work_dir = './work_dirs/ksound_sf'
load_from = None
resume_from = None
workflow = [('train', 1)]
gpu_ids = range(0, 1)
