# How Effective is Your Rebuttal? Identifying Causal Models in the OpenReview System – README

## Overview
This repository contains datasets and notebooks for analyzing how author rebuttals influence peer-review ratings (ICLR 2024–2025). It combines structured metadata with LLM-inferred signals and runs conditional independence tests (CIT), alongside visualization notebooks.

## Contents

- **`plot_independent_test.ipynb`**  
  Runs multiple Conditional Independence Tests (CIT) on the review-level dataset and produces diagnostic plots.

- **`plot_aggregate_independent_test.ipynb`**  
  Runs CIT on the aggregated (paper-level) dataset and summarizes results.

- **`plot_graphs.ipynb`**  
  Generates scatter and violin plots to visualize relationships between features and ratings.

- **`run_real_world_exp.py`**  
  Runs the real world experiments with our new propsoed CRL method and reuttal ICLR datasets. 
