import torch

def get_free_gpu():
    num_gpus = torch.cuda.device_count()
    max_free_memory = 0
    free_gpu_id = -1
    for i in range(4):
        try:
            with torch.cuda.device(i):
                free, total = torch.cuda.mem_get_info()
                if free > max_free_memory:
                    max_free_memory = free
                    free_gpu_id = i
        except RuntimeError as e:
            continue
    return str(free_gpu_id)

print(get_free_gpu())