
# Stability Based Generalization Bounds for Exponential Family Langevin Dynamics

This is the official implementation of experiments for "Stability Based Generalization Bounds for Exponential Family Langevin Dynamics"

## Requirements "Stability Based Generalization Bounds for Exponential Family Langevin Dynamics"

To install requirements:

```setup
conda env update --name envname --file environment.yml 
```

## Training

To train small CNN on MNIST and Fashion-MNIST using SGLD, run the following command:

```train
python train.py --data <mnist|fashion> --arch cnn1 -num-samples-per-class <0|1000|...> --batch-size 100 -num-epochs 50 -eps 4e-3 --alpha <5000|55000> --optimizer sgld
```

To train small CNN on MNIST and Fashion-MNIST using Noisy Sign-SGD, run the following command:

```train
python train.py --data <mnist|fashion> --arch cnn1 -num-samples-per-class <0|1000|...> --batch-size 100 -num-epochs 50 -eps 1e-4 --alpha <1|0.1|0.01|...> --optimizer noisy_signSGD

To train small CNN on CIFAR-10 using SGLD, run the following command:

```train
python train.py --data <mnist|fashion> --arch cnn1 -num-samples-per-class <0|1000|...> --batch-size 200 -num-epochs 1000 -eps 4e-3 --alpha <5000|55000> --optimizer sgld
```
