
import json
from collections import defaultdict

def load_and_normalize_beta(importance_dict_path):
    with open(importance_dict_path, "r") as f:
        importance_dict = json.load(f)
    male_scores = defaultdict(float, importance_dict.get("male", {}))
    female_scores = defaultdict(float, importance_dict.get("female", {}))
    all_tokens = set(male_scores.keys()).union(set(female_scores.keys()))

    token_bias = {token: male_scores.get(token, 0) - female_scores.get(token, 0) for token in all_tokens}

    min_beta = min(token_bias.values())
    max_beta = max(token_bias.values())

    if max_beta > 0 and min_beta < 0:  
        for token, value in token_bias.items():
            if value >= 0:
                token_bias[token] = value / max_beta  
            else:
                token_bias[token] = value / abs(min_beta)

    return token_bias
def predict_gender(classifier,image_embedding):
    image_embedding = image_embedding.reshape(1, -1)  # Ensure correct shape
    prob = classifier.predict_proba(image_embedding)[:, 1]  # Probability of male (1) vs female (0)
    return 2 * prob[0] - 1  # Normalize to range [-1, 1]