

import sys
import os

import numpy as np
import tqdm
import utils
from rouge_chinese import Rouge
import utils

import fire
from gensim.summarization import bm25
from transformers import AutoTokenizer
import time
import json

import random
import re
import string
from functools import partial
from multiprocessing import Pool
import jsonlines

# checkpoint = "bigscience/bloomz-7b1"
# tokenizer = AutoTokenizer.from_pretrained(checkpoint)


def encode_gpt4score_prompt(llm_output, prompt_path):
    """Encode multiple prompt instructions into a single string."""
    prompt = open(prompt_path, encoding="utf-8").read() + "\n"
    prompt_list = []
    for output in llm_output:
        prompt_ = prompt + output
        prompt_list.append(prompt_)
    return prompt_list

def find_word_in_string(w, s):
    return w in s

def get_all_prompt_file(filePath):
    file_name_ls = os.listdir(filePath)
    full_filepaths = []
    for filename in file_name_ls:
        full_filepath = filePath + '/' + filename
        full_filepaths.append(full_filepath)
    return full_filepaths

def read_llm_output(llm_output_file):
    # coding=utf-8
    outputs = []
    with open(llm_output_file, 'r', encoding='utf-8') as f:
        for item in jsonlines.Reader(f):
            instruction = item['instruction']
            response = item['response']
            conversation = "User 1: \"" + instruction + "\" User 2:\"" + response + "\""
            outputs.append(conversation)
            # print(prompts)
    return outputs

def post_process_gpt4_response(result):
    # raw_instructions = result["message"]["content"]
    # raw_instructions = result.choices[0].message.content
    raw_instructions = result[0][0]["message"]["content"]
    return raw_instructions


def generate_instruction_following_data(
        llm_output_path="./llm_output_t",
        api="gpt4score",
        model_name="gpt-3.5-turbo",
        prompt_path="./prompts/prompt_score.txt",
        request_batch_size=1,
        temperature=1.0,
        top_p=1.0,
):
    llm_output_filepaths = get_all_prompt_file(llm_output_path)
    for output_file in llm_output_filepaths:
        print(output_file)
        outputs = read_llm_output(output_file)
        prompt_list = encode_gpt4score_prompt(outputs, prompt_path)

        decoding_args = utils.OpenAIDecodingArguments(
            temperature=temperature,
            n=1,
            max_tokens=1024,  # hard-code to maximize the length. the requests will be automatically adjusted
            top_p=top_p,
            stop=["\n20", "20.", "20."],
        )
        save_file = 'chatgpt_score_gpt4/' + output_file.split('/')[2]
        # if not os.path.exists(save_file):
        #     os.mknod(save_file)
        with jsonlines.open(save_file, mode='a') as outf:
            # score_list = []
            for prompt in prompt_list:

                results = utils.openai_completion(
                    prompts=[prompt],
                    api=api,
                    model_name=model_name,
                    batch_size=request_batch_size,
                    decoding_args=decoding_args,
                    logit_bias={"50256": -100},  # prevent the <|endoftext|> token from being generated
                )
                score = post_process_gpt4_response(results)
                outf.write(score)

def main(task, **kwargs):
    globals()[task](**kwargs)


if __name__ == "__main__":
    fire.Fire(main)
