def compute_p_val(exp, num_vox_dict, mse_A, mse_B):
    
    stat, pvals = ttest_rel(mse_A, mse_B, axis=0, alternative='less')
    
    pvals[np.isnan(pvals)] = 1
    
    return pvals

def arrange_pvals_pd(pvals, exp, subjects_dict, br_labels_dict):
    
    
    pvals_dict = pd.DataFrame({'pvals': pvals, 
                               'subjects': subjects_dict[exp], 
                               'network': br_labels_dict[exp]})
    
    pvals_adj = []
    for s in np.unique(subjects_dict[exp]):
        for n in np.unique(br_labels_dict[exp]):
            pvals_sn = pvals_dict.loc[(pvals_dict.subjects==s)&(pvals_dict.network==n)]['pvals']
            pvals_adj_sn = false_discovery_control(pvals_sn, method='by')
            pvals_adj.extend(pvals_adj_sn)
            
    pvals_dict['pvals_adj'] = pvals_adj
    
    return pvals_dict

pvals_243_BLPW_PW = compute_p_val('243', num_vox_dict, mse_bil_PW_243, mse_PW_243)
pvals_384_BLPW_PW = compute_p_val('384', num_vox_dict, mse_bil_PW_384, mse_PW_384)
pvals_pd_243 = arrange_pvals_pd(pvals_243_BLPW_PW, '243', subjects_dict, br_labels_dict)
pvals_pd_384 = arrange_pvals_pd(pvals_384_BLPW_PW, '384', subjects_dict, br_labels_dict)

