Code Repo for paper *"When Source-Free Domain Adaptation Meets Learning with Noisy Labels"*
====

Overview
----
The code is mainly based on three SFDA baselines:

- SHOT: *Do we really need to access the source data? source hypothesis transfer for unsupervised domain adaptation*
- NRC: *Exploiting the intrinsic neighborhood structure for source-free domain adaptation.*
- G-SFDA: *Generalized source-free domain adaptation.*

We also utilized the [Transfer Learning Library](https://github.com/thuml/Transfer-Learning-Library) for the data processing.

Data Preparation
----
We utilized the dataset officially released or the colllected version from the baselines' repositories. We will provide all the links in the final version

Model
----
- Source Model Params: for the source models' params, we direclly utilized the pre-trained source model parameters provided by [SHOT](https://github.com/tim-learn/SHOT) and [NRC](https://github.com/Albert0147/NRC_SFDA)

Training (Adaptation)
----

- SHOT: ```cd ./shot```
  - VisDA: ```python train_visda.py```
  - Office Home: ```python train_officehome.py```
  - Office-31: ```python train_office31.py```
  - DomainNet: ```python train_domainnet.py```

- NRC: ```cd ./nrc```
  - VisDA: ```python train_visda.py```
  - Office Home: ```python ./office_home/train_tar.py```
  - Office-31: ```python ./offic31/train_tar.py```
  - DomainNet: ```python train_domainnet.py```

- G-SFDA: ```cd ./gsfda```
  - VisDA: ```python train_tar_visda.py```
  - Office Home: ```python train_tar_oh.py```
  - Office-31: ```python train_tar_o31.py```
  - DomainNet: ```python train_tar_domain.py```

Note: To develop a fair comparison between **baslines** and **baslines + our method**, we followed the baselines setting and did not heavily tune the hyper params. The details have been explained in the Appendix of the paper. More details will be included in the final version of our git repo.