# MixtureEnsembles




## Requirements

[BayesWatch's ImageNet Loader](https://github.com/BayesWatch/sequential-imagenet-dataloader) is required for ImageNet training.

```
Python 3, PyTorch == 1.8.1, torchvision == 0.9.1
```






## Training the model

To train a 36.5 million parameter model on CIFAR-100, do:

```
/train_models.sh 0,1 2 cifar100 swrn wavg_slide trained_ensemble --max_params 36500000 --param_groups -1 --bank_size 5 --ensemble_size 4
```

To adjust the number of parameters, simply adjust 'max_params'.


To train ImageNet, run the following command:

```
python main.py $BBPATH/imagenet --arch swrn_imagenet --wide 1 --dataset imagenet --epochs 90 --batch_size 64 --decay 0.0001 --no_nesterov --no_bn_decay --label_smoothing  0.1 --workers 16 --dist --warmup_epochs 10 --base_lr 0.1 --learning_rate 1.6 --schedule 30 60 80 --gammas 0.1 0.1 0.1 --job-id swrn_imagenet-ens4 --share_type wavg_slide --max_params 25600000 --param_groups -1 --bank_size 5 --ensemble_size 4 --ensemble_round_robin
```

This is trained with PyTorch DistributedDataParallel.



