#!/bin/bash

export PYTHONUNBUFFERED="True"

GPU_IDS=$1
NUM_GPUS=$2
DATASET=$3
NET=$4
SHARE=$5
TAG=$6

array=( $@ )
len=${#array[@]}
EXTRA_ARGS=${array[@]:6:$len}


case ${NET} in
    efficientnet)
        SCHEDULE="60 120 160"
        GAMMA="0.2 0.2 0.2"
        DECAY=5e-4
        EPOCHS=200
        BATCH_SIZE=64
        DEPTH=56
        WIDTH=1
        NET_NAME=${NET}
        ;;
    efficientnet_cifar)
        SCHEDULE="60 120 160"
        GAMMA="0.2 0.2 0.2"
        DECAY=5e-4
        EPOCHS=200
        BATCH_SIZE=128
        DEPTH=56
        WIDTH=1
        NET_NAME=${NET}
        ;;
    res)
        SCHEDULE="60 120 160"
        GAMMA="0.2 0.2 0.2"
        DECAY=5e-4
        EPOCHS=200
        BATCH_SIZE=128
        DEPTH=56
	WIDTH=1
        NET_NAME=${NET}
        ;;
    swrn)
	SCHEDULE="60 120 160"
	GAMMA="0.2 0.2 0.2"
	DECAY=5e-4
	EPOCHS=200
	BATCH_SIZE=128
	DEPTH=28
	WIDTH=10
	NET_NAME=${NET}
	;;
    densenet)
	SCHEDULE="150 225"
	GAMMA="0.1 0.1"
	DECAY=1e-4
	EPOCHS=300
	BATCH_SIZE=128
	DEPTH=100
	WIDTH=20
	case ${DATASET} in
            cifar10)
                NET_NAME=${NET}_cifar
                ;;
            cifar100)
                NET_NAME=${NET}_cifar
                ;;
            imagenet)
                NET_NAME=${NET}_imagenet
                ;;
            *)
        esac
	;;
    *)
	echo "No net given"
	exit
	;;
esac

case ${DATASET} in
    cifar10)
	CUDA_VISIBLE_DEVICES=${GPU_IDS} \
	    python main.py data --dataset ${DATASET} \
	    --arch ${NET_NAME} --depth ${DEPTH} --wide ${WIDTH} \
	    --share_type ${SHARE} --cutout --job-id ${TAG} \
	    --epochs ${EPOCHS} --batch_size ${BATCH_SIZE} \
	    --decay ${DECAY} --schedule ${SCHEDULE} \
	    --gammas ${GAMMA} --ngpu ${NUM_GPUS} \
	    ${EXTRA_ARGS}
	;;
    cifar100)
	CUDA_VISIBLE_DEVICES=${GPU_IDS} \
            python main_simple.py /scratch/data --dataset ${DATASET} \
            --arch ${NET_NAME} --depth ${DEPTH} --wide ${WIDTH} \
            --share_type ${SHARE} --cutout --job-id ${TAG} \
            --epochs ${EPOCHS} --batch_size ${BATCH_SIZE} \
            --decay ${DECAY} --schedule ${SCHEDULE} \
            --gammas ${GAMMA} --ngpu ${NUM_GPUS} \
            ${EXTRA_ARGS}
        ;;
    imagenet)
	CUDA_VISIBLE_DEVICES=${GPU_IDS} \
            python main.py data --dataset ${DATASET} \
            --arch ${NET_NAME} --depth ${DEPTH} --wide ${WIDTH} \
            --share_type ${SHARE} --job-id ${TAG} \
            --epochs ${EPOCHS} --batch_size ${BATCH_SIZE} \
            --decay ${DECAY} --schedule ${SCHEDULE} \
            --gammas ${GAMMA} --ngpu ${NUM_GPUS} \
            ${EXTRA_ARGS}
        ;;
    *)
        echo "No dataset given"
        exit
        ;;
esac

