## 📝 About
Self-Braking Tuning is a novel framework that unlocks the potential of large reasoning models to autonomously identify and terminate redundant reasoning, enabling the models to regulate their own reasoning processes without relying on external control mechanisms. 
During fine-tuning, we use the Megatron-LM framework, with related parameters specified in [`configs/train.yaml`](configs/train.yaml); for evaluation, we employ the vLLM framework as the inference engine, with corresponding parameters located in [`configs/evaluation.yaml`](configs/evaluation.yaml).
Here, we provide a complete data construction framework that can be applied to nearly any long-chain tuning dataset, generating corresponding self-braking data accordingly.

## 🛠️ Preparation Steps Before Starting
In *Let LLMs Break Free from Overthinking via Self-Braking Tuning*, we performed self-braking tuning based on the OpenR1-Math dataset. In fact, this approach is applicable to any long-chain reasoning dataset, as long as the reasoning segments are wrapped with `<think>` and `</think>` tags. It is worth noting that, prior to training, it is recommended to keep the model's max_position_embeddings set to 32,768. In addition, to extend the context length from 4k to 32k, we increase the RoPE frequency to 300k.

Our method requires access to an LLM, and the recommended way to provide this is by setting:

```
export APIKEY=<your_key>
```
**Tip**: To provide a convenient default option, we use the OpenAI API key.  However, for large-scale datasets, it is recommended to deploy open-source models locally using vLLM or other frameworks, and to leverage efficient methods such as batch processing for better scalability and cost efficiency.

## 🚀 Quick Start

### 1. Install Dependencies

```bash
pip install -r requirements.txt
```

### 2. Download

```bash
python models/model_download.py
python data/datasets/download_benchmarks.py
```

### 3. Get the baseline

```bash
python data/datasets/download_OpenR1-Math.py
```
### 4. Preprocess Data

```bash
python data/preprocessing/build_sbt-e.py
python data/preprocessing/build_sbt-d.py
```


### 5. Configure and Run Training / Evaluation

Refer to the config Settings in the following file:

* `train.yaml`: Training settings
* `evalution.yaml`: Evaluation settings



