# Install dependencies
```
conda env create -f environment.yml
```

# Ablation Study Replication (Table 1)

This guide provides instructions to replicate the ablation study results shown in Table 2.

## Steps to Run the Ablation

1. **Run the Parameter Ablation:**

    ```bash
    bash ./bash_scripts/submit_grid_search.sh
    ```

2. **Run the Evaluation for the Ablation:**

    ```bash
    bash ./bash_scripts/submit_ablation.sh
    ```

3. **Compile and Summarize the Results:**

    ```bash
    python ./compile_results.py
    ```

## Code layout
- `bash_scripts` - The bash scripts used to carry out the ablations
- `models` - Defines the models.
- `dataset` - Dataloading.
- `train_scripts` - The python scripts used to train the VAEs.
- `utils` - The utilities used in the codebase.

### Credits
* Soft-IntroVAE: Analyzing and Improving Introspective Variational Autoencoders, Daniel et al., CVPR 2021 - [Code](https://github.com/taldatech/soft-intro-vae-pytorch), [Paper](https://arxiv.org/abs/2012.13253)
* VAE with a VampPrior, Tomczak et al., AISTATS 2018  - [Code](https://github.com/jmtomczak/vae_vampprior), [Paper](https://arxiv.org/abs/1705.07120).
