import re
import os

def find_files(root_dir, pattern):
    matched_files = []
    regex = re.compile(pattern)

    for dirpath, _, filenames in os.walk(root_dir):
        for filename in filenames:
            full_path = os.path.join(dirpath, filename)
            if regex.match(full_path):
                matched_files.append(full_path)
    
    return matched_files