trial_hyperparams = {
  ########################################
  ########################################
  ##########   Opportunistic   ###########
  ########################################
  ########################################
  "opportunistic":{
        "123": {
              "dict1": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "gamma": 0.5,
                "num_samples_predict": 50,
                "num_episodes": 20000,
                "lr": 1e-3,
                "batchsize": 128,
                "print_every": 500,
                "eval_every": 100,
              },
              "dict2": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "gamma": 0.75,
                "num_samples_predict": 50,
                "num_episodes": 20000,
                "lr": 1e-3,
                "batchsize": 128,
                "print_every": 500,
                "eval_every": 100,
              },
              "dict3": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "gamma": 0.25,
                "num_samples_predict": 50,
                "num_episodes": 20000,
                "lr": 1e-3,
                "batchsize": 128,
                "print_every": 500,
                "eval_every": 100,
              },
        },
        "456": {
              "dict4": {
                "hidden_dim": 100,
                "num_hidden": 2,
                "gamma": 0.5,
                "num_samples_predict": 50,
                "num_episodes": 20000,
                "lr": 1e-3,
                "batchsize": 256,
                "print_every": 500,
                "eval_every": 100,
              },
              "dict5": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "gamma": 0.75,
                "num_samples_predict": 50,
                "num_episodes": 20000,
                "lr": 1e-3,
                "batchsize": 256,
                "print_every": 500,
                "eval_every": 100,
              },
              "dict6": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "gamma": 0.25,
                "num_samples_predict": 50,
                "num_episodes": 20000,
                "lr": 1e-4,
                "batchsize": 128,
                "print_every": 500,
                "eval_every": 100,
              },
        },
        "789": {
              "dict7": {
                "hidden_dim": 100,
                "num_hidden": 1,
                "gamma": 0.5,
                "num_samples_predict": 50,
                "num_episodes": 20000,
                "lr": 1e-3,
                "batchsize": 256,
                "print_every": 500,
                "eval_every": 100,
              },
              "dict8": {
                "hidden_dim": 200,
                "num_hidden": 1,
                "gamma": 0.75,
                "num_samples_predict": 50,
                "num_episodes": 20000,
                "lr": 1e-4,
                "batchsize": 256,
                "print_every": 500,
                "eval_every": 100,
              },
              "dict9": {
                "hidden_dim": 100,
                "num_hidden": 1,
                "gamma": 0.25,
                "num_samples_predict": 50,
                "num_episodes": 20000,
                "lr": 1e-3,
                "batchsize": 128,
                "print_every": 500,
                "eval_every": 100,
              },
        },
  },
  ########################################
  ########################################
  ##########        GDFS       ###########
  ########################################
  ########################################
  "gdfs":{
        "123": {
              "dict1": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "share_parameters": False,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 2,
                "temp_scale": 2.0,
              },
              "dict2": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "share_parameters": False,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 2,
                "temp_scale": 1.0,
              },
              "dict3": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "share_parameters": False,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 2,
                "temp_scale": 0.1,
              },
        },
        "456": {
              "dict4": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "share_parameters": True,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 2,
                "temp_scale": 2.0,
              },
              "dict5": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "share_parameters": True,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 2,
                "temp_scale": 1.0,
              },
              "dict6": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "share_parameters": True,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 2,
                "temp_scale": 0.1,
              },
        },
        "789": {
              "dict7": {
                "hidden_dim": 100,
                "num_hidden": 1,
                "share_parameters": True,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 512,
                "patience": 2,
                "temp_scale": 2.0,
              },
              "dict8": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "share_parameters": False,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 512,
                "patience": 2,
                "temp_scale": 1.0,
              },
              "dict9": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "share_parameters": True,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 512,
                "patience": 2,
                "temp_scale": 0.1,
              },
        },
  },
  ########################################
  ########################################
  ##########        DIME       ###########
  ########################################
  ########################################
  "dime":{
        "123": {
              "dict1": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "share_parameters": False,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 5,
                "eps_scale": 0.4,
              },
              "dict2": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "share_parameters": False,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 5,
                "eps_scale": 0.2,
              },
              "dict3": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "share_parameters": False,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 5,
                "eps_scale": 0.1,
              },
        },
        "456": {
              "dict4": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "share_parameters": True,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 5,
                "eps_scale": 0.4,
              },
              "dict5": {
                "hidden_dim": 100,
                "num_hidden": 2,
                "share_parameters": True,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 2,
                "eps_scale": 0.2,
              },
              "dict6": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "share_parameters": True,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 5,
                "eps_scale": 0.1,
              },
        },
        "789": {
              "dict7": {
                "hidden_dim": 100,
                "num_hidden": 1,
                "share_parameters": False,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 512,
                "patience": 5,
                "eps_scale": 0.4,
              },
              "dict8": {
                "hidden_dim": 100,
                "num_hidden": 3,
                "share_parameters": False,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-3,
                "batchsize": 256,
                "patience": 3,
                "eps_scale": 0.2,
              },
              "dict9": {
                "hidden_dim": 100,
                "num_hidden": 1,
                "share_parameters": True,
                "pretrain_epochs": 80,
                "pretrain_lr": 1e-3,
                "epochs": 15,
                "lr": 1e-4,
                "batchsize": 512,
                "patience": 5,
                "eps_scale": 0.1,
              },
        },
  },
  ########################################
  ########################################
  ##########        EDDI       ###########
  ########################################
  ########################################
  "eddi":{
        "123": {
              "dict1": {
                "c_dim": 200,
                "latent_dim": 200,
                "num_hidden_decoder": 2,
                "hidden_dim_decoder": 200,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 200,
                "epochs": 400,
                "lr": 1e-3,
                "batchsize": 128,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
              "dict2": {
                "c_dim": 200,
                "latent_dim": 200,
                "num_hidden_decoder": 2,
                "hidden_dim_decoder": 200,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 200,
                "epochs": 400,
                "lr": 1e-3,
                "batchsize": 512,
                "num_acquisition_samples": 50,
                "sig": 1.0,
                "patience": 5,
              },
              "dict3": {
                "c_dim": 50,
                "latent_dim": 100,
                "num_hidden_decoder": 2,
                "hidden_dim_decoder": 200,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 200,
                "epochs": 400,
                "lr": 1e-3,
                "batchsize": 128,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
        },
        "456": {
              "dict4": {
                "c_dim": 100,
                "latent_dim": 50,
                "num_hidden_decoder": 2,
                "hidden_dim_decoder": 200,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 200,
                "epochs": 400,
                "lr": 1e-3,
                "batchsize": 256,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
              "dict5": {
                "c_dim": 20,
                "latent_dim": 20,
                "num_hidden_decoder": 2,
                "hidden_dim_decoder": 200,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 200,
                "epochs": 400,
                "lr": 1e-3,
                "batchsize": 512,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
              "dict6": {
                "c_dim": 80,
                "latent_dim": 80,
                "num_hidden_decoder": 1,
                "hidden_dim_decoder": 100,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 100,
                "epochs": 400,
                "lr": 1e-3,
                "batchsize": 128,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
        },
        "789": {
              "dict7": {
                "c_dim": 250,
                "latent_dim": 250,
                "num_hidden_decoder": 2,
                "hidden_dim_decoder": 100,
                "num_hidden_encoder": 3,
                "hidden_dim_encoder": 100,
                "epochs": 400,
                "lr": 1e-3,
                "batchsize": 128,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
              "dict8": {
                "c_dim": 100,
                "latent_dim": 40,
                "num_hidden_decoder": 2,
                "hidden_dim_decoder": 75,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 75,
                "epochs": 400,
                "lr": 1e-3,
                "batchsize": 256,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
              "dict9": {
                "c_dim": 60,
                "latent_dim": 60,
                "num_hidden_decoder": 1,
                "hidden_dim_decoder": 200,
                "num_hidden_encoder": 3,
                "hidden_dim_encoder": 200,
                "epochs": 400,
                "lr": 1e-3,
                "batchsize": 512,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
        },
  },
  ########################################
  ########################################
  ##########        VAE        ###########
  ########################################
  ########################################
  "vae":{
        "123": {
              "dict1": {
                "latent_dim": 30,
                "num_hidden_decoder": 2,
                "hidden_dim_decoder": 100,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 100,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 100,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 128,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
              "dict2": {
                "latent_dim": 10,
                "num_hidden_decoder": 2,
                "hidden_dim_decoder": 200,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 200,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 100,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 128,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
              "dict3": {
                "latent_dim": 50,
                "num_hidden_decoder": 2,
                "hidden_dim_decoder": 150,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 150,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 200,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 128,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
        },
        "456": {
              "dict4": {
                "latent_dim": 30,
                "num_hidden_decoder": 1,
                "hidden_dim_decoder": 200,
                "num_hidden_encoder": 1,
                "hidden_dim_encoder": 200,
                "num_hidden_predictor": 1,
                "hidden_dim_predictor": 200,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 128,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
              "dict5": {
                "latent_dim": 50,
                "num_hidden_decoder": 2,
                "hidden_dim_decoder": 200,
                "num_hidden_encoder": 1,
                "hidden_dim_encoder": 150,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 200,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 256,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
              "dict6": {
                "latent_dim": 10,
                "num_hidden_decoder": 2,
                "hidden_dim_decoder": 100,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 100,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 100,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 512,
                "num_acquisition_samples": 50,
                "sig": 1.0,
                "patience": 5,
              },
        },
        "789": {
              "dict7": {
                "latent_dim": 30,
                "num_hidden_decoder": 2,
                "hidden_dim_decoder": 100,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 100,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 100,
                "epochs": 120,
                "lr": 5e-4,
                "batchsize": 64,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
              "dict8": {
                "latent_dim": 40,
                "num_hidden_decoder": 2,
                "hidden_dim_decoder": 200,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 200,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 200,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 128,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 3,
              },
              "dict9": {
                "latent_dim": 20,
                "num_hidden_decoder": 3,
                "hidden_dim_decoder": 250,
                "num_hidden_encoder": 3,
                "hidden_dim_encoder": 250,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 100,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 512,
                "num_acquisition_samples": 50,
                "sig": 0.2,
                "patience": 5,
              },
        },
  },
  ########################################
  ########################################
  ##########        MLP        ###########
  ########################################
  ########################################
  "fixed_mlp":{
        "123": {
              "dict1": {
                "hidden_dim": 200,
                "num_hidden": 2,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 5,
              },
              "dict2": {
                "hidden_dim": 100,
                "num_hidden": 2,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 5,
              },
              "dict3": {
                "hidden_dim": 200,
                "num_hidden": 1,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 5,
              },
        },
        "456": {
              "dict4": {
                "hidden_dim": 100,
                "num_hidden": 1,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 5,
              },
              "dict5": {
                "hidden_dim": 300,
                "num_hidden": 2,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 256,
                "patience": 5,
              },
              "dict6": {
                "hidden_dim": 100,
                "num_hidden": 2,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 2,
              },
        },
        "789": {
              "dict7": {
                "hidden_dim": 250,
                "num_hidden": 3,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 256,
                "patience": 10,
              },
              "dict8": {
                "hidden_dim": 50,
                "num_hidden": 2,
                "epochs": 80,
                "lr": 1e-3,
                "batchsize": 64,
                "patience": 5,
              },
              "dict9": {
                "hidden_dim": 120,
                "num_hidden": 2,
                "epochs": 120,
                "lr": 5e-4,
                "batchsize": 128,
                "patience": 5,
              },
        },
  },
  ########################################
  ########################################
  ##########        Ours        ##########
  ########################################
  ########################################
  "ours":{
        "123": {
              "dict1": {
                "latent_dim": 4,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 100,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 20,
                "num_samples_train": 100,
                "num_samples_predict": 200,
                "num_samples_acquire": 200,
                "ib_beta": 0.0005,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 5,
              },
              "dict2": {
                "latent_dim": 4,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 250,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 150,
                "num_samples_train": 100,
                "num_samples_predict": 200,
                "num_samples_acquire": 200,
                "ib_beta": 0.001,
                "epochs": 120,
                "lr": 5e-4,
                "batchsize": 128,
                "patience": 5,
              },
              "dict3": {
                "latent_dim": 4,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 100,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 20,
                "num_samples_train": 100,
                "num_samples_predict": 200,
                "num_samples_acquire": 200,
                "ib_beta": 0.001,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 5,
              },
        },
        "456": {
              "dict4": {
                "latent_dim": 6,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 150,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 50,
                "num_samples_train": 100,
                "num_samples_predict": 200,
                "num_samples_acquire": 200,
                "ib_beta": 0.0005,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 128,
                "patience": 5,
              },
              "dict5": {
                "latent_dim": 4,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 250,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 150,
                "num_samples_train": 100,
                "num_samples_predict": 200,
                "num_samples_acquire": 200,
                "ib_beta": 0.005,
                "epochs": 120,
                "lr": 3e-4,
                "batchsize": 128,
                "patience": 5,
              },
              "dict6": {
                "latent_dim": 8,
                "num_hidden_predictor": 1,
                "hidden_dim_predictor": 250,
                "num_hidden_encoder": 1,
                "hidden_dim_encoder": 100,
                "num_samples_train": 100,
                "num_samples_predict": 200,
                "num_samples_acquire": 200,
                "ib_beta": 0.0001,
                "epochs": 120,
                "lr": 1e-3,
                "batchsize": 256,
                "patience": 5,
              },
        },
        "789": {
              "dict7": {
                "latent_dim": 4,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 180,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 40,
                "num_samples_train": 100,
                "num_samples_predict": 200,
                "num_samples_acquire": 200,
                "ib_beta": 0.0008,
                "epochs": 120,
                "lr": 5e-4,
                "batchsize": 128,
                "patience": 8,
              },
              "dict8": {
                "latent_dim": 6,
                "num_hidden_predictor": 3,
                "hidden_dim_predictor": 250,
                "num_hidden_encoder": 3,
                "hidden_dim_encoder": 100,
                "num_samples_train": 100,
                "num_samples_predict": 200,
                "num_samples_acquire": 200,
                "ib_beta": 0.001,
                "epochs": 120,
                "lr": 5e-4,
                "batchsize": 256,
                "patience": 5,
              },
              "dict9": {
                "latent_dim": 8,
                "num_hidden_predictor": 2,
                "hidden_dim_predictor": 250,
                "num_hidden_encoder": 2,
                "hidden_dim_encoder": 100,
                "num_samples_train": 100,
                "num_samples_predict": 200,
                "num_samples_acquire": 200,
                "ib_beta": 0.005,
                "epochs": 120,
                "lr": 5e-4,
                "batchsize": 128,
                "patience": 5,
              },
        },
  },
}