from avici import simulate_data

data_distributions = {
    'lin-gauss': "./environments/lin-gauss.yaml",
    'lin-gauss-heterosked': "./environments/lin-gauss-heterosked.yaml",
    'lin-laplace': "./environments/lin-laplace.yaml",
    'rff-gauss': "./environments/rff-gauss.yaml",
    'rff-gauss-heterosked': "./environments/rff-gauss-heterosked.yaml",
    'rff-laplace': "./environments/rff-laplace.yaml",
    'gene-ecoli': "./environments/gene-ecoli.yaml"
}

def generate_synthetic_data(d, n, n_interv, distribution="lin-gauss", seed=0):
    if distribution not in data_distributions:
        raise NotImplementedError("Distrubution not available")
    distribution_path = data_distributions[distribution]
    g, expr, I = simulate_data(d=d, n=n, path=distribution_path, n_interv=n_interv * d, seed=seed)


    return g, expr, I
