from sklearn.preprocessing import MinMaxScaler, StandardScaler, RobustScaler
import numpy as np

# Define scaling functions as classes for sklearn style fit-transform approach
class MinMaxScalerFunc:
    def __init__(self):
        self.scaler = MinMaxScaler()
    def fit(self, data):
        self.scaler.fit(data)
    def transform(self, data):
        return self.scaler.transform(data)

class StandardScalerFunc:
    def __init__(self):
        self.scaler = StandardScaler()
    def fit(self, data):
        self.scaler.fit(data)
    def transform(self, data):
        return self.scaler.transform(data)

class RobustScalerFunc:
    def __init__(self):
        self.scaler = RobustScaler()
    def fit(self, data):
        self.scaler.fit(data)
    def transform(self, data):
        return self.scaler.transform(data)

class MaxAbsScalerFunc:
    def __init__(self):
        self.norm = None
    def fit(self, data):
        absolutes = np.abs(data)
        self.norm = np.max(absolutes, axis=0)
    def transform(self, data):
        return data / self.norm
scaling_classes = {
    "Min-Max Scaling": MinMaxScalerFunc,
    "Standard Scaling": StandardScalerFunc,
    "Robust Scaling": RobustScalerFunc,
    "Max Abs Scaling": MaxAbsScalerFunc
}