#!/bin/bash

# Define an array of values for d
declare -a d_vals=(10 30) 

# Define an array of values for edge density
declare -a p_vals=(1 2)

# Define an array of values for seed
declare -a seed_vals=(0 1 2 3 4)

# Loop through each combination of d and seed values
for d in "${d_vals[@]}"
do
    for p in "${p_vals[@]}"
    do
        for seed in "${seed_vals[@]}"
        do
            # Run the Python script with the current values of d and seed
            python3 scripts/interventional_benchmark.py --n 5000 --n_per_intervention 100 --d $d --s $p --seed $seed --model all --force True --sweep_frac True

            # Add a newline for separation between iterations
            echo ""
        done
    done
done
