from langchain_core.pydantic_v1 import BaseModel, Field
from voyager.agents import interaction

class WorldModel(BaseModel):
    biome: str
    time_of_day: str
    nearby_blocks: list[str] | str
    health: int | str
    hunger: int | str
    position: tuple[int, int, int] | str
    equipment: list[str] | str
    inventory_used: int | str
    inventory: list[str] | str
    critique: str
    desire: str
    task_beliefs: str
    interaction_beliefs: str
    perception_beliefs: str
    collaborator_perspectives: str
