

from reader.glue_reader import GlueReaderForDP, GlueReaderWithNoise, R2D2GlueReader, GlueReaderWithShortcut


def create_glue_dataset(tokenizer, task_type, glue_dir, dataset_type, 
                        max_batch_len, max_batch_size, sampler, 
                        empty_label_idx=-1,
                        tree_path=None, 
                        cache_dir=None):
    dataset = R2D2GlueReader(
        task_type,
        glue_dir,
        dataset_type,
        tokenizer,
        max_batch_len=max_batch_len,
        max_batch_size=max_batch_size,
        random=sampler == "random",
        seperator=" ",
        tree_path=tree_path,
        cache_dir=cache_dir
    )
    return dataset