from tensorflow.keras.callbacks import TensorBoard

class TensorBoardExt(TensorBoard):
    def __init__(self, **kwargs):
        super().__init__(**kwargs)

    def on_epoch_end(self, epoch, logs=None):
        logs = logs or {}
        logs.update({'lr': self.model.optimizer.learning_rate(epoch)})
        super().on_epoch_end(epoch, logs=logs)
