import tensorflow as tf

def resize(image, label, size):
    sizeTarget = tf.stack(size)
    image = tf.image.resize(image, sizeTarget)
    label = tf.image.resize(label, sizeTarget, method='nearest')

    return image, label

def random_resize(image, label, crop_size, ignore_label=255):
    resize = tf.random.uniform(shape=[], minval=0.75, maxval=1.1)
    height = tf.cast(tf.cast(tf.shape(image)[0], tf.float32) * resize, tf.int32)
    width = tf.cast(tf.cast(tf.shape(image)[1], tf.float32) * resize, tf.int32)
    image = tf.image.resize(image, tf.stack([height, width]))
    image = tf.image.resize_with_crop_or_pad(image, crop_size[0], crop_size[1])
    label = tf.image.resize(label, tf.stack([height, width]), method='nearest')
    label = label - ignore_label
    label = tf.image.resize_with_crop_or_pad(label, crop_size[0], crop_size[1])
    label = label + ignore_label # such that padded zeros are ignored

    return image, label

def flip(image, label):
    flip = tf.random.uniform(shape=[]) < 0.5
    image = tf.cond(flip, lambda: tf.image.flip_left_right(image), lambda: image)
    label = tf.cond(flip, lambda: tf.image.flip_left_right(label), lambda: label)

    return image, label
