import labels
import numpy as np

labelMap= []
for label in labels.labels:
    labelMap.append([label.id, label.trainId])
labelMap = np.array(labelMap, dtype=np.int)[:-1]
numClasses = len(labelMap)
assert(np.all(np.equal(labelMap[:, 0], np.arange(numClasses))))

labelMap = labelMap[:, 1]
print(labelMap)

# save map
np.save('data/cityscapes_ignore', labelMap)

# example
a = np.random.randint(numClasses, size=(4, 3))
print(a)
print(labelMap[a])
