import os
import tensorflow as tf
from data.datasets import Camvid
from utils import MeanIoUIgnore

data_dir = '/fs/scratch/'
dataExt = '360x480'
pathDataTrain = os.path.join(data_dir, 'Data', 'camvid', 'camvid-' + dataExt + '-train.npz')
pathDataValid = os.path.join(data_dir, 'Data', 'camvid', 'camvid-' + dataExt + '-val.npz')
pathDataTest = os.path.join(data_dir, 'Data', 'camvid', 'camvid-' + dataExt + '-test.npz')

dataset = Camvid(pathDataTrain, pathDataValid, pathTest=pathDataTest,
        num_layers=1, batch_size=1, crop=[352, 480], merge_train_valid=False)
dataTrain = dataset.get_train_set()
dataValid = dataset.get_valid_set()
dataTest = dataset.get_test_set()
inputShape = dataset.get_shape()
labelShape = inputShape[:2] + (1,)
numClasses = int(dataset.get_num_classes())

miou = MeanIoUIgnore(numClasses)
for j in range(10):
    for i, (image, label) in enumerate(dataValid):
        random_labels = tf.random.uniform(labelShape, 0, numClasses, dtype=tf.int32)
        miou.update_state(label['output_1'], random_labels)
print(miou.result())
