# Beat the Machine — AI Triage Demo
*(AI in Healthcare: Triage Through 7 Cases and When It Fails)*

## Overview
This interactive demo lets you step into the role of a healthcare triage decision-maker. 
You’ll review 7 short patient cases with basic vital signs and decide their urgency (Red, Orange, or Green). 
After each case, compare your choice with the “ground truth” and an AI system’s prediction, learning where the AI gets it right — and wrong.

## Audience
- No coding or AI background required.
- Designed for high school students, undergraduates in non-CS majors, educators, healthcare professionals, and the general public.

## System Requirements
- Python: 3.9+
- Packages: Listed in `requirements.txt`
- Internet: Not required (all assets are local)
- Display: 13" or larger recommended for full layout visibility

## Setup (First Time)
1. Ensure Python 3.9+ is installed.
2. Open a terminal in the demo folder.
3. Install dependencies:
   ```bash
   pip install -r requirements.txt
   ```
4. Ensure the `assets/` folder is in the same directory as `triage_gradio_app_v4.py`.

## Running the Demo
1. In the terminal, run:
   ```bash
   python triage_gradio_app_v4.py
   ```
2. Wait for the **Gradio interface link** to appear. Example:
   ```
   Running on local URL: http://127.0.0.1:7860
   ```
3. Click the link or paste it into a browser.
4. The demo will open in your default web browser.

## How to Play
1. Read the patient story and vital signs.
2. Select a triage level:
   - Severe (Red) — needs urgent attention
   - Intermediate (Orange) — monitor closely
   - Mild (Green) — likely safe to wait
3. Click **Reveal AI prediction** to see what the AI decided.
4. Adjust vital signs with sliders to explore “what-if” scenarios.
5. Click **Next case** to continue through all 7 cases.
6. At the end, view your final score compared to the AI’s score.

## Included Files
- `triage_gradio_app_v4.py` — Main demo application
- `assets/` — Images and graphics used in the demo
- `cover_page.pdf` — NeurIPS-required cover page
- `offline_handout.pdf` — Takeaway summary of the demo concepts
- `sample_screenshots/` — Example screenshots from the demo

## Credits
Developed by **[Dr. Syed Ahmar Shah** — Senior Research Fellow (Associate Professor) & Director of Innovation, Usher Institute, University of Edinburgh  
Contact: **ahmar.shah@ed.ac.uk** | LinkedIn: **https://www.linkedin.com/in/syed-ahmar-shah-47541510/**
