# SpaRFT
      
### Dataset
**[DeepScaleR Preview Dataset](https://huggingface.co/datasets/agentica-org/DeepScaleR-Preview-Dataset)**  

### Parameters
- `dataset_path`: Path to dataset. The dataset can be found in `data` folder.
- `L == 1200`: Required to reach the final answer.
- `bs = 1`, `gc = 8`: Use these settings to avoid out-of-memory (OOM) errors.

- `nepochs`: Number of epochs. For Deepscaler (uniform, easy, hard,..), each epoch corresponds to 1 batch of dataset, thus `nepochs=1250`, which corresponds to `len(dataset)/batch_size=10000/8`.

## Setup
```bash
# Install Python
conda create -n sparft python=3.10
conda activate sparft
# Install other dependencies
pip install -r requirements.txt
```

## Experiments on Deepscaler

### SPaRFT
- Qwen3-0.6B - 7 clusters:
```bash
VLLM_USE_V1=0 python run_deepscaler.py --model_name=Qwen/Qwen3-0.6B --dataset_path=./data/deepscaler_uniform_train.parquet --mode=cluster_thompson --uncertainty_metric=None --num_shots=0 --bs=1 --gc=8 --L=1200 --nepochs=1250 --T=0.0 --eta=50 --sensitivity=2.0 --beta=0.4 --d_min=0.0 --d_max=100.0 --test --cluster_method diverse --n_clusters 7
```

## Evaluation
### Setup:
- Another environment is needed to avoid conflict
```bash
# Install Python
conda create -n sparft_eval python=3.10
conda activate sparft_eval
# Install other dependencies
pip install -r requirements_eval.txt
```

- Using LightEval: 
```bash
python run_eval.py --task=gsm8k --model_name=path/to/model/ --model_seed=model_seed
```
