import cplex
import networkx as nx
import numpy as np

def cplex_solve(graph):
    prob = cplex.Cplex()
    '''prob.set_log_stream(None)
    prob.set_error_stream(None)
    prob.set_warning_stream(None)
    prob.set_results_stream(None)'''
    prob.parameters.timelimit.set(100.0)
    prob.set_problem_name("Minimum Vertex Cover")
    prob.set_problem_type(cplex.Cplex.problem_type.LP)

    prob.objective.set_sense(prob.objective.sense.minimize)
    names = list(map(str,list(graph.nodes)))
    n = graph.number_of_nodes()
    w_obj = [1]*n
    low_bnd = [0]*n
    upr_bnd = [1]*n
    prob.variables.add(names=names, obj=w_obj, lb=low_bnd, ub=upr_bnd)
    all_int = [(var, prob.variables.type.integer) for var in names]
    prob.variables.set_types(all_int)

    edges = [[str(x), str(y)] for x,y in list(graph.edges)]
    constraints = list(zip(edges, [[1,1] for _ in range(len(edges))]))

    constraint_names = ["".join(x[0]) for x in constraints]

    # Each edge must have at least one vertex
    rhs = [1] * len(constraints)

    constraint_senses = ["G"] * len(constraints)

    prob.linear_constraints.add(names=constraint_names,
                                lin_expr=constraints,
                                senses=constraint_senses,
                                rhs=rhs)

    #print("Problem Type: %s" % prob.problem_type[prob.get_problem_type()])
    prob.solve()
    #print("Solution result is: %s" % prob.solution.get_status_string())
    return np.sum(prob.solution.get_values())

