import networkx as nx
import matplotlib.pyplot as plt
from matplotlib.colors import ListedColormap
import os

def visualize_result(costs, order, nx_graph, problem, index=0, node_size=1200, neptune_run=None, show=False, save_pdf=False):

    n = nx_graph.number_of_nodes()

    pos2 = nx.spring_layout(nx_graph, seed=15, weight=1)  # Seed layout for reproducibility
    pos4 = nx.spring_layout(nx_graph, seed=781, weight=1)  # Seed layout for reproducibility
    pos_circular = nx.circular_layout(nx_graph)  # Seed layout for reproducibility
    layouts = [pos2, pos4, pos_circular]

    order_list = order.cpu().squeeze().numpy().tolist()

    labels = [(order_list[i], i) for i in range(n)]

    fig_size = min(6.5 + n / 10, 25)

    if save_pdf:
        if not os.path.exists('./img'):
            os.makedirs('./img')

    if problem.NAME == "GC" or problem.NAME == "DefectiveGC":
        coloring = nx.algorithms.coloring.greedy_color(nx_graph, lambda g, dict: order_list)
        coloring_sorted = [coloring[k] for k in range(len(coloring))]

        color_list = ['#000000', '#0173B2', '#DE8F05', '#D55E00', '#CC78BC', '#029E73', '#CA9161', '#FBAFE4', '#949494', '#ECE133', '#56B4E9', '#E00C1B', '#BCFFCF', '#841BE0', '#75D3FF', '#E0BD24', '#A60B1B', '#FFD1E6', '#03579E', '#DDDDDD', '#AAAAAA', '#777777']
        color_pal = ListedColormap(color_list)

        mapped_colors = [color_list[i] for i in coloring_sorted]

        id = 0
        for layout in layouts:
            id = id+1

            fig = plt.figure(num=0, figsize=(fig_size, fig_size), edgecolor=None)

            _ = nx.draw_networkx_nodes(nx_graph, layout, node_color='white', edgecolors=mapped_colors,
                    cmap=color_pal, node_size=node_size, alpha=1.0, linewidths=4.0)

            _ = nx.draw_networkx_edges(nx_graph, layout, alpha=0.9)

            _ = nx.draw_networkx_labels(nx_graph, layout, dict(labels), font_color="black", font_weight="normal", font_family="serif", font_size=17)

            fig.set_edgecolor(None)
            fig.set_frameon(None)
            fig.get_axes()[0].axis('off')

            if neptune_run is not None:
                neptune_run["val/inspection/" + str(n) + "/" + str(index) + "_color"].log(fig)

            if save_pdf:
                plt.savefig('./img/' + str(n) + "_" + str(index) + "_color_" + str(id) + '.pdf', bbox_inches="tight")

            if show:
                plt.show()

            fig.clf()
            plt.close(fig)

    # MVC
    if problem.NAME == "MVC":
        cost = costs.cpu().squeeze().item()

        mvc = [1] * len(order_list)

        for j in range(int(cost)):
            mvc[order_list[j]] = 0

        id = 0
        for layout in layouts:
            id = id+1

            fig = plt.figure(num=0, figsize=(fig_size, fig_size))

            color_list = ['#000000', '#BBBBBB']
            mapped_color = [color_list[i] for i in mvc]

            _ = nx.draw_networkx_nodes(nx_graph, layout, node_color='white', edgecolors=mapped_color,
                                       node_size=node_size, alpha=1.0, linewidths=4.0)

            _ = nx.draw_networkx_edges(nx_graph, layout, alpha=0.9)

            _ = nx.draw_networkx_labels(nx_graph, layout, dict(labels), font_color="black", font_weight="normal",
                                        font_family="serif", font_size=17)

            fig.set_edgecolor(None)
            fig.set_frameon(None)
            fig.get_axes()[0].axis('off')

            if neptune_run is not None:
                neptune_run["val/inspection/" + str(n) + "/" + str(index) + "_mvc"].log(fig)

            if save_pdf:
                plt.savefig('./img/' + str(n) + "_" + str(index) + "_mvc_" + str(id) + '.pdf', bbox_inches="tight")

            if show:
                plt.show()

            fig.clf()
            plt.close(fig)
