# CroissantLLM: Code submission

This repository regroups code related to data gathering, data processing, and data analysis for the CroissantLLM training project, 
as well as model training and evaluation code.

All code is public on Github and will be linked in the final manuscript.


## Repository structure

- FMTI indicators: Contains the FMTI indicators detail for the CroissantLLM model
- croissant-llm-training: Code for training the CroissantLLM model
- llm-data-hub: Code for data gathering, data processing, and data analysis
- lm-evaluation-harness: Code for evaluating the CroissantLLM model (forked from EleutherAI Evaluation Harness)
  - Relevant code for FrenchBench evaluation tasks can be found in `lm_eval/tasks/french_bench`


## Datasets

All datasets used in the training of CroissantLLM are publicly available and can be found in the HuggingFace Datasets Hub we do not link here for anonymity reasons.

All evaluation datasets are also publicly available and can be found in the HuggingFace Datasets Hub we do not link here for anonymity reasons.

Sizes of the datasets are prohibitive to be included in this repository.

## Abstract

We introduce CroissantLLM, a 1.3B language model pretrained on a set of 3T English and French tokens, to bring to the research and industrial community a high-performance, fully open-sourced bilingual model that runs swiftly on consumer-grade local hardware. To that end, we pioneer the approach of training an intrinsically bilingual model with a 1:1 English-to-French pretraining data ratio, a custom tokenizer, and bilingual finetuning datasets. We release the training dataset, notably containing a French split with manually curated, high-quality, and varied data sources. To assess performance outside of English, we craft a novel benchmark, FrenchBench, consisting of an array of classification and generation tasks, covering various orthogonal aspects of model performance in the French Language. Additionally, rooted in transparency and to foster further Large Language Model research, we release codebases, and dozens of checkpoints across various model sizes, training data distributions, and training steps, as well as fine-tuned Chat models, and strong translation models. We evaluate our model through the FMTI framework, and validate 81 % of the transparency criteria, far beyond the scores of even most open initiatives. This work enriches the NLP landscape, breaking away from previous English-centric work in order to strengthen our understanding of multilinguality in language models. 
