# DEPTH-GUIDED SELF-SUPERVISED LEARNING: SEEING THE WORLD IN 3D

ICLR 2024 Anonymous Submission
## Code Structure
```
    src/ -- Running Self-Supervised Pretraining and Evaluation including the proposed methods.
    AdaMPI/ -- Code to generate 3D Views.
    DPT/ -- Code to generate Depth maps
```
## SSL Pre-Training

BYOL Baseline on ImageNet-100
```
python main_ssl.py --log_results=T --arch resnet18 --num_views 1 --epochs 200 --exp_str test --simclr_transforms -j 12 --dataset imagenet-100 --root_path <IMAGENET-100-PATH> --wd 1e-4 -b 256 --lr 0.2 --use_amp --method byol
```

BYOL+3D Views on ImageNet-100

```
python main_ssl.py --log_results=T --arch resnet18 --num_views 1 --epochs 200 --exp_str test --simclr_transforms -j 16 --dataset imagenet-100 --root_path <IMAGENET-100-PATH> --aug_root_path <3D-VIEWS-PATH> --wd 1e-4 -b 256 --lr 0.2 --use_amp --method byol --adampi_prob 0.5
```

BYOL+Depth (p=0.3)

```
python main_ssl_depth.py --log_results=T --arch resnet18 --num_views 1 --epochs 200 --exp_str re6 --simclr_transforms -j 12 --dataset imagenet-100 --root_path  <IMAGENET-100-PATH> --depth_path <DEPTH-MAP-PATH> --wd 1e-4 -b 256 --lr 0.2 --use_amp --method byol --drop_depth 0.3
```

## Linear Evaluation
ImageNet-100
```
python main_linear_eval_in100.py --log_results=T --exp_str test --checkpoint_path <CHECKPOINT_PATH> --lr 30.0 -j 12 --dataset imagenet-100 --root_path <IMAGENET-100-PATH> --use_amp --method byol --wd 0.0
```

## Generating Depth Maps

Refer to `run.sh` in DPT folder.

## Generating 3D Views

Refer to `run.sh` in AdaMPI folder.