# Fairness for Workers Who Pull the Arms: An Index Based Policy for Allocation of Restless Bandit Tasks 

## Setup
Our Fair Index-based Policy for allocation of N Restless Bandit tasks among M workers consists of the 3-step framework illustrated below, mentioned at the start of Methodology (Section 4 of submission)

- Main file for Step 1 (compute Whittle Indices for all arm-worker pairs) and Step 2 (Adjust Indices for inter-action effects) is `mwrmab/algos/whittle_binary_search.py`
- Main file for Step 3 (Balanced Actions) is `mwrmab/algos/decoupled_methods.py`

#### To install follow these directions (generic version):

- Install the repo:
- `pip3 install -e .`
- Create the directory structure:
- `bash make_dirs.sh`

If you have any issues with mpi4py or tkinter, try these steps (on linux)
- `apt-get update`
- `sudo apt install python3-mpi4py`
- `sudo apt-get install python3-tk`

Then run `pip3 install -e .` again once these successfully install.

#### If you want to run Hawkins baseline, you need to install gurobi and gurobipy by following these steps
- In a web browser Register for a Gurobi account or login at https://www.gurobi.com/downloads/end-user-license-agreement-academic/ 
- Navigate to https://www.gurobi.com/downloads/ and select `Gurobi Optimizer`
- Review the EULA, then click `I accept the End User License Agreement`
- Identify the latest installation... as of writing, it is 9.5.0, and the following commands will reflect that. However, if the latest version has changed, you can replace 9.5.0 in the following commands with the newer version number and/or links on the Gurobi website.
- `cd ~`
- `mkdir tools`
- `cd tools`
- `wget https://packages.gurobi.com/9.5/gurobi9.5.0_linux64.tar.gz`
- `tar xvzf gurobi9.5.0_linux64.tar.gz`
- Add the following lines to your ~/.bashrc file, e.g., via `vim ~/.bashrc`
```
export GUROBI_HOME="~/tools/gurobi912/linux64"
export PATH="${PATH}:${GUROBI_HOME}/bin"
export LD_LIBRARY_PATH="${LD_LIBRARY_PATH}:${GUROBI_HOME}/lib"
``` 
- Run `source ~/.bashrc`
- On the browser, navigate to https://www.gurobi.com/downloads/end-user-license-agreement-academic/
- Review the conditions, then click `I accept these conditions`
- Copy the command that looks like `grbgetkey 00000000-0000-0000-0000-000000000000`, then paste and run in the server terminal window
- Enter `Y` to select the default options when prompted
- `cd ~/MultiWorkerRMAB/`
- `pip install gurobipy`

## Running Code 
### Experiment Domains

To run all experiments, i.e., those needed to reproduce Figure 2 and 3, run:
`bash run_paper_experiments.sh`

To make the plots, run:
`python3 paper_plotting_code/experiments.py`


We evaluate our framework on three domains: (1) constant unitary costs, (2) ordered workers, and (3) specialist domain, each highlighting various challenging dimensions of the MWRMAB problem.
- **Constant unitary costs:** The cost associated with all worker-arm pairs is the same, but transition probabilities differ. Run `run_constantCosts.py`. 
- **Ordered workers:** Ordering among the workers such that the highest (or lowest) ranked worker has the highest (or lowest) probability of transitioning any arm to good state. Run `run_orderedWorkers.py`.
- **Specialist domain:** Highlights the need to consider inter-action effects via Step 2. Run `run_decoupledCounterexample.py`.

Details on the parameters can be found by running `python3 run_constantCosts.py --help`, `python3 run_orderedWorkers.py --help`, `python3 run_decoupledCounterexample.py --help`.

Figure 4 and 5 can be generated by changing N and B parameters to the corresponding values. 

